"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientInvoiceRoutes", {
    enumerable: true,
    get: function() {
        return patientInvoiceRoutes;
    }
});
const _constants = require("@tamanu/constants");
const _invoice = require("@tamanu/shared/utils/invoice");
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientInvoiceRoutes = _express.default.Router();
const encounterOrderByKeys = [
    'encounterType'
];
const invoiceOrderByKeys = [
    'date',
    'displayId',
    'status'
];
patientInvoiceRoutes.get('/:id/invoices', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('list', 'Invoice');
    const { models, params, query } = req;
    const { order = 'ASC', orderBy, rowsPerPage = 10, page = 0 } = query;
    const patientId = params.id;
    const data = await models.Invoice.findAll({
        include: [
            ...models.Invoice.getFullReferenceAssociations(),
            {
                model: models.Encounter,
                as: 'encounter',
                where: {
                    patientId
                },
                order: orderBy && encounterOrderByKeys.includes(orderBy) ? [
                    [
                        orderBy,
                        order.toUpperCase()
                    ]
                ] : undefined
            }
        ],
        order: orderBy && invoiceOrderByKeys.includes(orderBy) ? [
            [
                orderBy,
                order.toUpperCase()
            ]
        ] : undefined,
        limit: rowsPerPage,
        offset: page * rowsPerPage
    });
    const count = await models.Invoice.count({
        include: [
            {
                model: models.Encounter,
                as: 'encounter',
                where: {
                    patientId
                }
            }
        ]
    });
    res.send({
        count,
        data
    });
}));
patientInvoiceRoutes.get('/:id/invoices/totalOutstandingBalance', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('list', 'Invoice');
    const { models, params } = req;
    const patientId = params.id;
    const invoices = await models.Invoice.findAll({
        where: {
            status: _constants.INVOICE_STATUSES.FINALISED
        },
        include: [
            ...models.Invoice.getFullReferenceAssociations(),
            {
                model: models.Encounter,
                as: 'encounter',
                where: {
                    patientId
                }
            }
        ]
    });
    const balance = invoices.reduce((acc, invoice)=>acc + (0, _invoice.getInvoiceSummary)(invoice).patientPaymentRemainingBalance, 0);
    res.send({
        result: balance
    });
}));

//# sourceMappingURL=patientInvoice.js.map