"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "scheduledVaccine", {
    enumerable: true,
    get: function() {
        return scheduledVaccine;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const scheduledVaccine = _express.default.Router();
scheduledVaccine.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('read', 'PatientVaccine');
    const { models: { ScheduledVaccine }, query: { category } } = req;
    const where = {
        visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT,
        ...category && {
            category
        }
    };
    const scheduledVaccines = await ScheduledVaccine.findAll({
        where
    });
    const results = scheduledVaccines.map((sv)=>sv.dataValues);
    res.send(results);
}));

//# sourceMappingURL=scheduledVaccine.js.map