"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "TimeSyncTask", {
    enumerable: true,
    get: function() {
        return TimeSyncTask;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let TimeSyncTask = class TimeSyncTask extends _tasks.ScheduledTask {
    getName() {
        return 'TimeSyncTask';
    }
    async run() {
        return this.context.timesync.attemptSync(_config.default.sync);
    }
    constructor(context){
        const { schedule, jitterTime, enabled } = _config.default.schedules.timeSync;
        super(schedule, _logging.log, jitterTime, enabled), _define_property(this, "context", null);
        this.context = context;
        this.runImmediately();
    }
};

//# sourceMappingURL=TimeSyncTask.js.map