"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "REPORT_OBJECTS", {
    enumerable: true,
    get: function() {
        return REPORT_OBJECTS;
    }
});
const _reportDefinitions = require("./reportDefinitions");
const REPORT_OBJECTS = {};
// To check if a user has permissions we need to have an object
// with a constructor name that matches the 'noun' of the permission
// and also the id as a field.
let Report = class Report {
    constructor(id){
        this.id = id;
    }
};
_reportDefinitions.REPORT_DEFINITIONS.forEach((definition)=>{
    const { id } = definition;
    REPORT_OBJECTS[id] = new Report(id);
});

//# sourceMappingURL=reportObjects.js.map