"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirPatientLink", {
    enumerable: true,
    get: function() {
        return FhirPatientLink;
    }
});
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
const _reference = require("./reference");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const TYPES = [
    'replaced-by',
    'replaces',
    'refer',
    'seealso'
];
let FhirPatientLink = class FhirPatientLink extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            other: _reference.FhirReference.asYup().required(),
            type: _yup.string().oneOf([
                null,
                ...TYPES
            ]).required()
        }).noUnknown();
    }
    static fake(model, { fieldName }, id) {
        return new this({
            type: (0, _lodash.sample)(TYPES),
            other: _reference.FhirReference.fake(model, {
                fieldName
            }, id)
        });
    }
};

//# sourceMappingURL=patientLink.js.map