"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "initBugsnag", {
    enumerable: true,
    get: function() {
        return initBugsnag;
    }
});
const _log = require("./log.js");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function initBugsnag(options) {
    const { default: Bugsnag } = await Promise.resolve().then(()=>/*#__PURE__*/ _interop_require_wildcard(require("@bugsnag/js")));
    const BugsnagPluginExpress = await Promise.resolve().then(()=>/*#__PURE__*/ _interop_require_wildcard(require("@bugsnag/plugin-express")));
    Bugsnag.start({
        ...options,
        plugins: [
            BugsnagPluginExpress
        ],
        logger: _log.log,
        redactedKeys: options.redactedKeys ? options.redactedKeys.map((redact)=>{
            if (redact.startsWith('/') && redact.endsWith('/i')) {
                return new RegExp(redact.slice(1, -1), 'i');
            }
            if (redact.startsWith('/') && redact.endsWith('/')) {
                return new RegExp(redact.slice(1, -1));
            }
            return redact;
        }) : undefined
    });
}

//# sourceMappingURL=bugsnag.js.map