"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getUploadedData", {
    enumerable: true,
    get: function() {
        return getUploadedData;
    }
});
const _multiparty = /*#__PURE__*/ _interop_require_default(require("multiparty"));
const _tmpdir = require("./tmpdir");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function getMultipartData(req) {
    const form = new _multiparty.default.Form({
        autoFiles: true,
        uploadDir: await (0, _tmpdir.tmpdir)()
    });
    return new Promise((resolve, reject)=>{
        form.parse(req, (err, fields, files)=>{
            if (err) {
                reject(err);
            } else {
                const { jsonData, ...otherFields } = fields;
                try {
                    const parsedData = jsonData ? JSON.parse(jsonData) : {};
                    const fileInfo = files.file ? {
                        file: files.file[0].path,
                        deleteFileAfterImport: true
                    } : {};
                    resolve({
                        ...parsedData,
                        ...otherFields,
                        ...fileInfo
                    });
                } catch (e) {
                    reject(e);
                }
            }
        });
    });
}
async function getUploadedData(req) {
    const contentType = (req.headers['content-type'] || '').split(';')[0].trim().toLowerCase();
    switch(contentType){
        case 'multipart/form-data':
            return getMultipartData(req);
        case 'application/json':
            return {
                ...req.body
            };
        default:
            throw new Error(`Couldn't understand content type ${contentType}`);
    }
}

//# sourceMappingURL=getUploadedData.js.map