"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EncounterDetailsExtended", {
    enumerable: true,
    get: function() {
        return EncounterDetailsExtended;
    }
});
const _DataSection = require("./DataSection");
const _Layout = require("../Layout");
const _DataItem = require("./DataItem");
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _dateTime = require("@tamanu/utils/dateTime");
const _languageContext = require("../../pdf/languageContext");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const EncounterDetailsExtended = ({ encounter, discharge })=>{
    const { location, examiner, department, startDate, endDate, reasonForEncounter } = encounter;
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    const clinicianText = getTranslation('general.localisedField.clinician.label.short', 'Clinician', {
        casing: 'lower'
    });
    return /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: getTranslation('pdf.encounterDetails.title', 'Encounter details'),
        hideBottomRule: true
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.localisedField.facility.label', 'Facility'),
        value: location.facility.name,
        key: "facility"
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.supervisingClinician.label', 'Supervising :clinician', {
            replacements: {
                clinician: clinicianText
            }
        }),
        value: examiner.displayName,
        key: "supervisingClinician"
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.dischargingClinician.label', 'Discharging :clinician', {
            replacements: {
                clinician: clinicianText
            }
        }),
        value: discharge?.discharger?.displayName,
        key: "dischargingClinician"
    }), discharge?.disposition?.name && /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.localisedField.dischargeDisposition.label', 'Discharge disposition'),
        value: discharge?.disposition?.name,
        key: "dischargeDisposition"
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.department.label', 'Department'),
        value: department.name,
        key: "department"
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('encounter.dateOfAdmission.label', 'Date of admission'),
        value: (0, _dateTime.formatShort)(startDate),
        key: "dateOfAdmission"
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('encounter.dateOfDischarge.label', 'Date of discharge'),
        value: discharge ? (0, _dateTime.formatShort)(endDate) : getTranslation('general.encounterDischargedNotApplicable', 'n/a (encounter in progress)'),
        key: "dateOfDischarge"
    })), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('encounter.reasonForEncounter.label', 'Reason for encounter'),
        value: reasonForEncounter,
        key: "reasonForEncounter"
    }));
};

//# sourceMappingURL=EncounterDetailsExtended.js.map