"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getReportQueryReplacements", {
    enumerable: true,
    get: function() {
        return getReportQueryReplacements;
    }
});
const _datefns = require("date-fns");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const START_OF_EPOCH = '1970-01-01 00:00:00';
const getFromDate = (dateRange, { toDate, fromDate })=>{
    const defaultedToDate = toDate || (0, _dateTime.getCurrentDateTimeString)();
    if (fromDate) {
        return (0, _dateTime.toDateTimeString)((0, _datefns.startOfDay)((0, _datefns.parseISO)(fromDate)));
    }
    switch(dateRange){
        case _constants.REPORT_DEFAULT_DATE_RANGES.ALL_TIME:
            return START_OF_EPOCH;
        case _constants.REPORT_DEFAULT_DATE_RANGES.EIGHTEEN_YEARS:
            return (0, _dateTime.toDateTimeString)((0, _datefns.startOfDay)((0, _datefns.subYears)((0, _datefns.parseISO)(defaultedToDate), 18)));
        case _constants.REPORT_DEFAULT_DATE_RANGES.THIRTY_DAYS:
            // If we have a toDate, but no fromDate, run 30 days prior to the toDate
            return (0, _dateTime.toDateTimeString)((0, _datefns.startOfDay)((0, _datefns.subDays)((0, _datefns.parseISO)(defaultedToDate), 30)));
        case _constants.REPORT_DEFAULT_DATE_RANGES.SEVEN_DAYS:
            return (0, _dateTime.toDateTimeString)((0, _datefns.startOfDay)((0, _datefns.subDays)((0, _datefns.parseISO)(defaultedToDate), 7)));
        case _constants.REPORT_DEFAULT_DATE_RANGES.TWENTY_FOUR_HOURS:
            return (0, _dateTime.toDateTimeString)((0, _datefns.subDays)((0, _datefns.parseISO)(defaultedToDate), 1));
        case _constants.REPORT_DEFAULT_DATE_RANGES.NEXT_THIRTY_DAYS:
            return (0, _dateTime.toDateTimeString)((0, _datefns.startOfDay)(toDate ? (0, _datefns.subDays)((0, _datefns.parseISO)(toDate), 30) : (0, _datefns.addDays)(new Date(), 1)));
        default:
            throw new Error('Unknown date range for report generation');
    }
};
const getToDate = (dateRange, { toDate, fromDate })=>{
    if (toDate) {
        return (0, _dateTime.toDateTimeString)((0, _datefns.endOfDay)((0, _datefns.parseISO)(toDate)));
    }
    switch(dateRange){
        case _constants.REPORT_DEFAULT_DATE_RANGES.ALL_TIME:
        case _constants.REPORT_DEFAULT_DATE_RANGES.EIGHTEEN_YEARS:
        case _constants.REPORT_DEFAULT_DATE_RANGES.THIRTY_DAYS:
        case _constants.REPORT_DEFAULT_DATE_RANGES.SEVEN_DAYS:
        case _constants.REPORT_DEFAULT_DATE_RANGES.TWENTY_FOUR_HOURS:
            return (0, _dateTime.getCurrentDateTimeString)();
        case _constants.REPORT_DEFAULT_DATE_RANGES.NEXT_THIRTY_DAYS:
            return (0, _dateTime.toDateTimeString)((0, _datefns.endOfDay)((0, _datefns.addDays)(fromDate ? (0, _datefns.parseISO)(fromDate) : (0, _datefns.addDays)(new Date(), 1), 30)));
        default:
            throw new Error('Unknown date range for report generation');
    }
};
const getReportQueryReplacements = async (paramDefinitions, facilityId, params = {}, dateRange = _constants.REPORT_DEFAULT_DATE_RANGES.TWENTY_FOUR_HOURS)=>{
    const paramDefaults = paramDefinitions.reduce((obj, { name })=>({
            ...obj,
            [name]: null
        }), {});
    return {
        ...paramDefaults,
        ...params,
        fromDate: getFromDate(dateRange, params),
        toDate: getToDate(dateRange, params),
        currentFacilityId: facilityId
    };
};

//# sourceMappingURL=getReportQueryReplacements.js.map