import { z } from 'zod';
export declare const PatientSchema: z.ZodObject<{
    id: z.ZodString;
    displayId: z.ZodString;
    firstName: z.ZodString;
    middleName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    lastName: z.ZodString;
    dateOfBirth: z.ZodString;
    sex: z.ZodEnum<{
        MALE: string;
        FEMALE: string;
        OTHER: string;
    }>;
    village: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export type Patient = z.infer<typeof PatientSchema>;
//# sourceMappingURL=patient.schema.d.ts.map