<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function tan

Calculate the tangent of a value. `tan(x)` is equal to `sin(x) / cos(x)`.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.tan(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Unit &#124; Array &#124; Matrix | Function input

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix | Tangent of x


## Examples

```js
math.tan(0.5)                    // returns number 0.5463024898437905
math.sin(0.5) / math.cos(0.5)    // returns number 0.5463024898437905
math.tan(math.pi / 4)            // returns number 1
math.tan(math.unit(45, 'deg'))   // returns number 1
```


## See also

[atan](atan.md),
[sin](sin.md),
[cos](cos.md)
