/**
 * @param {Node | Document} nodeOrDocument
 * @param {ToJsonOptions} [options]
 */
export function toJson(nodeOrDocument: Node | Document, options?: ToJsonOptions | undefined): unknown;
/**
 * @param {unknown} value
 * @param {object} [options]
 * @param {string} [options.nodeName]
 * @param {boolean} [options.allowEntries]
 * @param {boolean} [options.allowEntriesInArrays]
 * @param {boolean} [options.allowEntriesInObjects]
 * @param {boolean} [options.allowEntriesInRoot]
 * @param {string | number} [options.indentation]
 */
export function fromJson(value: unknown, { nodeName, allowEntries, allowEntriesInArrays, allowEntriesInObjects, allowEntriesInRoot, indentation: indentationStep, }?: {
    nodeName?: string | undefined;
    allowEntries?: boolean | undefined;
    allowEntriesInArrays?: boolean | undefined;
    allowEntriesInObjects?: boolean | undefined;
    allowEntriesInRoot?: boolean | undefined;
    indentation?: string | number | undefined;
} | undefined): Node;
/**
 * @param {string} string
 * @param {(value: unknown, key: string | number, data: {location: Node | import('@bgotink/kdl').Entry}) => unknown} [reviver]
 */
export function parse(string: string, reviver?: ((value: unknown, key: string | number, data: {
    location: Node | import('@bgotink/kdl').Entry;
}) => unknown) | undefined): unknown;
/**
 * @param {unknown} value
 * @param {unknown} [_]
 * @param {string | number} [indentation]
 */
export function stringify(value: unknown, _?: unknown, indentation?: string | number | undefined): string;
export class InvalidJsonInKdlError extends Error {
    /** @param {string} message */
    constructor(message: string);
}
export type ToJsonOptions = {
    ignoreValues?: boolean | undefined;
    type?: string | undefined;
    reviver?: ((value: unknown, key: string | number, data: {
        location: Node | import('@bgotink/kdl').Entry;
    }) => unknown) | undefined;
};
import { Node } from "@bgotink/kdl";
import { Document } from "@bgotink/kdl";
