'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const isWeakSet = require('../_chunk/isWeakSet-CvIdTA.js');
const isPlainObject = require('../_chunk/isPlainObject-octpoD.js');

function isBoolean(x) {
    return typeof x === 'boolean';
}

function isError(value) {
    return value instanceof Error;
}

function isString(value) {
    return typeof value === 'string';
}

function isSymbol(value) {
    return typeof value === 'symbol';
}

exports.isArrayBuffer = isWeakSet.isArrayBuffer;
exports.isBlob = isWeakSet.isBlob;
exports.isBuffer = isWeakSet.isBuffer;
exports.isDate = isWeakSet.isDate;
exports.isEqual = isWeakSet.isEqual;
exports.isEqualWith = isWeakSet.isEqualWith;
exports.isFile = isWeakSet.isFile;
exports.isFunction = isWeakSet.isFunction;
exports.isJSONArray = isWeakSet.isJSONArray;
exports.isJSONObject = isWeakSet.isJSONObject;
exports.isJSONValue = isWeakSet.isJSONValue;
exports.isLength = isWeakSet.isLength;
exports.isMap = isWeakSet.isMap;
exports.isNil = isWeakSet.isNil;
exports.isNotNil = isWeakSet.isNotNil;
exports.isNull = isWeakSet.isNull;
exports.isRegExp = isWeakSet.isRegExp;
exports.isSet = isWeakSet.isSet;
exports.isUndefined = isWeakSet.isUndefined;
exports.isWeakMap = isWeakSet.isWeakMap;
exports.isWeakSet = isWeakSet.isWeakSet;
exports.isPlainObject = isPlainObject.isPlainObject;
exports.isPrimitive = isPlainObject.isPrimitive;
exports.isTypedArray = isPlainObject.isTypedArray;
exports.isBoolean = isBoolean;
exports.isError = isError;
exports.isString = isString;
exports.isSymbol = isSymbol;
