"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MedicationSetExporter", {
    enumerable: true,
    get: function() {
        return MedicationSetExporter;
    }
});
const _constants = require("@tamanu/constants");
const _DefaultDataExporter = require("./DefaultDataExporter");
const _sequelize = require("sequelize");
let MedicationSetExporter = class MedicationSetExporter extends _DefaultDataExporter.DefaultDataExporter {
    async getData() {
        const medicationSets = await this.models.ReferenceData.findAll({
            where: {
                type: _constants.REFERENCE_TYPES.MEDICATION_SET
            }
        });
        const medicationTemplates = await this.models.ReferenceDataRelation.findAll({
            attributes: [
                'referenceDataId',
                'referenceDataParentId'
            ],
            where: {
                referenceDataParentId: {
                    [_sequelize.Op.in]: medicationSets.map(({ id })=>id)
                }
            }
        });
        return medicationSets.map((medicationSet)=>({
                ...medicationSet.dataValues,
                medicationTemplates: medicationTemplates.filter(({ referenceDataParentId })=>referenceDataParentId === medicationSet.id).map(({ referenceDataId })=>referenceDataId).join(',')
            }));
    }
};

//# sourceMappingURL=MedicationSetExporter.js.map