"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProcedureTypeExporter", {
    enumerable: true,
    get: function() {
        return ProcedureTypeExporter;
    }
});
const _DefaultDataExporter = require("./DefaultDataExporter");
const _constants = require("@tamanu/constants");
let ProcedureTypeExporter = class ProcedureTypeExporter extends _DefaultDataExporter.DefaultDataExporter {
    async getData() {
        const procedureTypes = await this.models.ReferenceData.findAll({
            where: {
                type: _constants.REFERENCE_TYPES.PROCEDURE_TYPE
            },
            include: {
                model: this.models.Survey,
                as: 'surveys'
            }
        });
        return procedureTypes.map(({ dataValues: { surveys, ...rest } })=>({
                ...rest,
                formLink: surveys.map(({ id })=>id).join(',')
            }));
    }
    getHeadersFromData(data) {
        return Object.keys(data[0]);
    }
};

//# sourceMappingURL=ProcedureTypeExporter.js.map