"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "readHandler", {
    enumerable: true,
    get: function() {
        return readHandler;
    }
});
const _datefns = require("date-fns");
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _fhir = require("@tamanu/shared/utils/fhir");
const _sleepAsync = require("@tamanu/utils/sleepAsync");
const _errors = require("@tamanu/errors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const UNRESOLVED_RESOURCE_AWAIT_TIMEOUT = 20 * 1000; // 20 seconds
const UNRESOLVED_RESOURCE_AWAIT_BACKOFF = 0.5 * 1000; // 0.5 seconds
function readHandler(FhirResource) {
    return (0, _expressasynchandler.default)(async (req, res)=>{
        const { id } = req.params;
        // TODO: support _summary and _elements
        // const parameters = new Map([
        //   normaliseParameter(['_summary', RESULT_PARAMETERS._summary], {
        //     path: [],
        //     sortable: false,
        //   }),
        // ]);
        // const query = await parseRequest(req, parameters);
        const record = await FhirResource.findByPk(id);
        if (!record) throw new _fhir.NotFound(`no ${FhirResource.fhirName} with id ${id}`);
        let totalAwaitedTime = 0;
        while(!record.resolved && totalAwaitedTime < UNRESOLVED_RESOURCE_AWAIT_TIMEOUT){
            const nextSleepTime = Math.max(Math.min(totalAwaitedTime + UNRESOLVED_RESOURCE_AWAIT_BACKOFF, UNRESOLVED_RESOURCE_AWAIT_TIMEOUT - totalAwaitedTime), 0);
            await (0, _sleepAsync.sleepAsync)(nextSleepTime);
            totalAwaitedTime += nextSleepTime;
            await record.reload();
        }
        if (!record.resolved) {
            throw new _errors.ValidationError(`Awaiting resource ${FhirResource.fhirName}/${id} resolution timed out after ${totalAwaitedTime}ms`);
        }
        res.header('Last-Modified', (0, _datefns.formatRFC7231)(record.lastUpdated));
        // TODO: support ETag when we have full versioning support
        // TODO: support _pretty
        res.send(record.asFhir());
    });
}

//# sourceMappingURL=read.js.map