/**
 * Fetch the sequelize field definition
 *
 * Generally want the .field value for the in-sql column name
 */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    findField: function() {
        return findField;
    },
    pushToQuery: function() {
        return pushToQuery;
    }
});
function findField(Model, field) {
    if (Model.rawAttributes && Model.rawAttributes[field]) {
        return Model.rawAttributes[field];
    }
    if (Model.fieldRawAttributesMap && Model.fieldRawAttributesMap[field]) {
        return Model.fieldRawAttributesMap[field];
    }
    return field;
}
function pushToQuery(query, param, value) {
    const insert = query.get(param) ?? [];
    insert.push(value);
    query.set(param, insert);
}

//# sourceMappingURL=common.js.map