"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "issueVdsNcSignature", {
    enumerable: true,
    get: function() {
        return issueVdsNcSignature;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _crypto = /*#__PURE__*/ _interop_require_default(require("crypto"));
const _jsoncanonicalize = require("json-canonicalize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function issueVdsNcSignature(data, { models }) {
    const signer = await models.Signer.findActive();
    if (!signer) {
        throw new Error('Cannot issue signature, no active signer');
    }
    const privateKey = signer.decryptPrivateKey(_config.default.integrations.signer.keySecret);
    const canonData = Buffer.from((0, _jsoncanonicalize.canonicalize)(data), 'utf8');
    const sign = _crypto.default.createSign('SHA256');
    sign.update(canonData);
    sign.end();
    const signature = sign.sign({
        key: privateKey,
        dsaEncoding: 'ieee-p1363'
    });
    await signer.increment('signaturesIssued');
    return {
        algorithm: 'ES256',
        signature
    };
}

//# sourceMappingURL=Crypto.js.map