"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "DefaultLanguageTranslatedReferenceData", {
    enumerable: true,
    get: function() {
        return DefaultLanguageTranslatedReferenceData;
    }
});
const _constants = require("@tamanu/constants");
const _dataMigrations = require("@tamanu/database/dataMigrations");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let DefaultLanguageTranslatedReferenceData = class DefaultLanguageTranslatedReferenceData extends _dataMigrations.CursorDataMigration {
    async getQuery() {
        return `
      with updated as (
      update translated_strings
      set language = '${_constants.DEFAULT_LANGUAGE_CODE}'
      where id in (
          select id
          from translated_strings
          where language = 'en' and split_part(string_id, '.', 1) = '${_constants.REFERENCE_DATA_TRANSLATION_PREFIX}' and id > $fromId
          order by id
          limit $limit
      )
      returning id
      )
      select
        max(id::text) as "maxId",
        count(id) as "count"
      from updated;
    `;
    }
    constructor(...args){
        super(...args), _define_property(this, "lastMaxId", '');
    }
};
_define_property(DefaultLanguageTranslatedReferenceData, "defaultBatchSize", Number.MAX_SAFE_INTEGER);
_define_property(DefaultLanguageTranslatedReferenceData, "defaultDelayMs", 50);

//# sourceMappingURL=DefaultLanguageTranslatedReferenceData.js.map