"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReformatMultiSelectSurveyResponses", {
    enumerable: true,
    get: function() {
        return ReformatMultiSelectSurveyResponses;
    }
});
const _dataMigrations = require("@tamanu/database/dataMigrations");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let ReformatMultiSelectSurveyResponses = class ReformatMultiSelectSurveyResponses extends _dataMigrations.CursorDataMigration {
    async getQuery() {
        return `
      WITH updated AS (
        UPDATE survey_response_answers as sra
        SET body = ('["' || REPLACE(sra.body, ', ', '","') || '"]')
        WHERE id IN (
            SELECT survey_response_answers.id
            FROM survey_response_answers
            JOIN program_data_elements ON survey_response_answers.data_element_id = program_data_elements.id
            WHERE program_data_elements.type = 'MultiSelect'
            AND survey_response_answers.id > $fromId
            AND survey_response_answers.body NOT LIKE '["%"]'
            ORDER BY survey_response_answers.id
            LIMIT $limit
        )
        RETURNING id
      )
      SELECT
        MAX(id::text) AS "maxId",
        COUNT(id) AS "count"
      FROM updated;
    `;
    }
    constructor(...args){
        super(...args), _define_property(this, "lastMaxId", '00000000-0000-0000-0000-000000000000');
    }
};
_define_property(ReformatMultiSelectSurveyResponses, "defaultBatchSize", Number.MAX_SAFE_INTEGER);
_define_property(ReformatMultiSelectSurveyResponses, "defaultDelayMs", 50);

//# sourceMappingURL=ReformatMultiSelectSurveyResponses.js.map