"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SignerWorkingPeriodChecker", {
    enumerable: true,
    get: function() {
        return SignerWorkingPeriodChecker;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let SignerWorkingPeriodChecker = class SignerWorkingPeriodChecker extends _tasks.ScheduledTask {
    getName() {
        return 'SignerWorkingPeriodChecker';
    }
    async run() {
        const { Signer } = this.context.store.models;
        const expired = await Signer.findAll({
            where: {
                workingPeriodEnd: {
                    [_sequelize.Op.lt]: _sequelize.Sequelize.NOW
                }
            },
            // hard limit: there really should only ever be zero or one
            // expired signers at any given time, but just in case:
            limit: 5
        });
        if (!expired.length) {
            return Promise.resolve();
        }
        _logging.log.info(`${expired.length} VDS-NC signer(s) have reached the end of their working period`);
        return Promise.all(expired.map(async (signer)=>{
            signer.set({
                privateKey: null
            });
            await signer.save();
            await signer.destroy();
            _logging.log.info(`Signer ${signer.id}'s private key deleted (issued ${signer.signaturesIssued} signatures)`);
        }));
    }
    constructor(context){
        const conf = _config.default.schedules.signerWorkingPeriodChecker;
        const { schedule, jitterTime, enabled } = conf;
        super(schedule, _logging.log, jitterTime, enabled);
        this.config = conf;
        this.context = context;
    }
};

//# sourceMappingURL=SignerWorkingPeriodChecker.js.map