"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('user_recently_viewed_patients', {
        id: {
            type: _sequelize.default.UUID,
            defaultValue: _sequelize.default.fn('uuid_generate_v4'),
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        user_id: {
            type: _sequelize.default.STRING,
            references: {
                model: 'users',
                key: 'id'
            },
            onDelete: 'cascade',
            allowNull: false
        },
        patient_id: {
            type: _sequelize.default.STRING,
            references: {
                model: 'patients',
                key: 'id'
            },
            onDelete: 'cascade',
            allowNull: false
        }
    });
    await query.addConstraint('user_recently_viewed_patients', {
        fields: [
            'user_id',
            'patient_id'
        ],
        type: 'unique'
    });
}
async function down(query) {
    await query.dropTable('user_recently_viewed_patients');
}

//# sourceMappingURL=153_addUserRecentlyViewedPatientsTable.js.map