"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('death_revert_logs', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        revert_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        death_data_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        patient_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'patients',
                key: 'id'
            }
        },
        reverted_by_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        }
    });
}
async function down(query) {
    await query.dropTable('death_revert_logs');
}

//# sourceMappingURL=1673295206628-createDeathRevertLogsTable.js.map