"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('vital_logs', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        date: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        previous_value: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        new_value: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        reason_for_change: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        recorded_by_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        answer_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'survey_response_answers',
                key: 'id'
            }
        }
    });
}
async function down(query) {
    await query.dropTable('vital_logs');
}

//# sourceMappingURL=1685405020041-addVitalLogTable.js.map