"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    const dupes = await query.sequelize.query(`
    SELECT COUNT(*), name 
    FROM report_definitions
    GROUP BY name
    HAVING COUNT(*) > 1
  `, {
        type: _sequelize.QueryTypes.SELECT
    });
    if (dupes.length > 0) {
        const names = dupes.map((d)=>`"${d.name}" (x${d.count})`).join(',');
        throw new Error(`Found some report definitions in the db that have the same name as each other. Please resolve the duplication before proceeding.\nThe duplicated names are: ${names}`);
    }
    await query.sequelize.query(`
    ALTER TABLE report_definitions ADD CONSTRAINT report_definitions_name_key UNIQUE (name);
  `);
}
async function down(query) {
    await query.sequelize.query(`
    ALTER TABLE report_definitions DROP CONSTRAINT report_definitions_name_key;
 `);
}

//# sourceMappingURL=1692245527896-uniqueReportDefinitionNames.js.map