/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('tasks', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        encounter_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'encounters',
                key: 'id'
            }
        },
        name: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        due_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        end_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: true
        },
        requested_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        request_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            defaultValue: 'todo'
        },
        note: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        frequency_value: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        frequency_unit: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        high_priority: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: true
        },
        parent_task_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: true,
            references: {
                model: 'tasks',
                key: 'id'
            }
        },
        completed_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        completed_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: true
        },
        completed_note: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        not_completed_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        not_completed_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: true
        },
        not_completed_note: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        todo_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        todo_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: true
        },
        todo_note: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        deleted_by_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        deleted_time: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: true
        },
        deleted_reason_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('task_designations', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        task_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'tasks',
                key: 'id'
            }
        },
        designation_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('task_templates', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        reference_data_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            unique: true,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        high_priority: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: true
        },
        frequency_value: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        frequency_unit: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('task_template_designations', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        task_template_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'task_templates',
                key: 'id'
            }
        },
        designation_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('user_designations', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        designation_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('user_designations');
    await query.dropTable('task_template_designations');
    await query.dropTable('task_templates');
    await query.dropTable('task_designations');
    await query.dropTable('tasks', {});
}

//# sourceMappingURL=1723098124005-addTaskingTables.js.map