/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('invoice_item_discounts', 'type', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false,
        defaultValue: _constants.INVOICE_ITEMS_DISCOUNT_TYPES.PERCENTAGE
    });
    await query.renameColumn('invoice_item_discounts', 'percentage', 'amount');
}
async function down(query) {
    await query.removeColumn('invoice_item_discounts', 'type', {});
    await query.renameColumn('invoice_item_discounts', 'amount', 'percentage', {});
}

//# sourceMappingURL=1733217291655-addDiscountAmountToInvoiceItemDiscountTable.js.map