import { Model } from './Model';
import { buildPatientSyncFilterViaPatientId } from '../sync/buildPatientSyncFilterViaPatientId';
import { type InitOptions, type Models } from '../types/model';
export declare class PatientDeathData extends Model {
    id: string;
    birthWeight?: number;
    carrierAge?: number;
    carrierPregnancyWeeks?: number;
    externalCauseDate?: string;
    lastSurgeryDate?: string;
    externalCauseLocation?: string;
    externalCauseNotes?: string;
    fetalOrInfant?: boolean;
    hoursSurvivedSinceBirth?: number;
    manner?: string;
    pregnancyContributed?: string;
    recentSurgery?: string;
    stillborn?: string;
    wasPregnant?: string;
    withinDayOfBirth?: boolean;
    outsideHealthFacility?: boolean;
    primaryCauseTimeAfterOnset?: number;
    antecedentCause1TimeAfterOnset?: number;
    antecedentCause2TimeAfterOnset?: number;
    antecedentCause3TimeAfterOnset?: number;
    isFinal?: boolean;
    visibilityStatus: string;
    patientId?: string;
    clinicianId?: string;
    facilityId?: string;
    primaryCauseConditionId?: string;
    antecedentCause1ConditionId?: string;
    antecedentCause2ConditionId?: string;
    antecedentCause3ConditionId?: string;
    lastSurgeryReasonId?: string;
    carrierExistingConditionId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
    }>;
    static buildPatientSyncFilter: typeof buildPatientSyncFilterViaPatientId;
}
//# sourceMappingURL=PatientDeathData.d.ts.map