import { type InitOptions } from 'sequelize';
import { FhirResource } from './Resource';
import type { Models } from '../../types/model';
export declare class FhirMedicationRequest extends FhirResource {
    identifier?: Record<string, any>;
    status: string;
    intent: string;
    groupIdentifier?: Record<string, any>;
    category?: Record<string, any>;
    subject?: Record<string, any>;
    encounter?: Record<string, any>;
    medication?: Record<string, any>;
    authoredOn?: Date;
    requester?: Record<string, any>;
    recorder?: Record<string, any>;
    note?: Record<string, any>;
    dosageInstruction?: Record<string, any>;
    dispenseRequest?: Record<string, any>;
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    updateMaterialisation(): Promise<void>;
    static queryToFindUpstreamIdsFromTable(upstreamTable: string, table: string, id: string): Promise<{
        where: {
            id: string;
        };
        include?: undefined;
    } | {
        include: {
            model: typeof import("../Prescription").Prescription;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("../Prescription").Prescription;
            as: string;
            required: boolean;
            include: {
                model: typeof import("../ReferenceData").ReferenceData;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("../PharmacyOrder").PharmacyOrder;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("../PharmacyOrder").PharmacyOrder;
            as: string;
            required: boolean;
            include: {
                model: typeof import("../User").User;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("../PharmacyOrder").PharmacyOrder;
            as: string;
            required: boolean;
            include: {
                model: typeof import("../Encounter").Encounter;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("../PharmacyOrder").PharmacyOrder;
            as: string;
            required: boolean;
            include: {
                model: typeof import("../Encounter").Encounter;
                as: string;
                required: boolean;
                include: {
                    model: typeof import("../Patient").Patient;
                    as: string;
                    required: boolean;
                    where: {
                        id: string;
                    };
                }[];
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("../PharmacyOrder").PharmacyOrder;
            as: string;
            required: boolean;
            include: {
                model: typeof import("../Encounter").Encounter;
                as: string;
                required: boolean;
                include: {
                    model: typeof import("../Location").Location;
                    as: string;
                    required: boolean;
                    include: {
                        model: typeof import("../Facility").Facility;
                        as: string;
                        required: boolean;
                        where: {
                            id: string;
                        };
                    }[];
                }[];
            }[];
        }[];
        where?: undefined;
    } | null>;
}
//# sourceMappingURL=FhirMedicationRequest.d.ts.map