"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "findSyncSnapshotRecords", {
    enumerable: true,
    get: function() {
        return findSyncSnapshotRecords;
    }
});
const _case = require("case");
const _sequelize = require("sequelize");
const _manageSnapshotTable = require("./manageSnapshotTable");
const findSyncSnapshotRecords = async (sequelize, sessionId, direction, fromId = 0, limit = Number.MAX_SAFE_INTEGER, recordType, additionalWhere)=>{
    const tableName = (0, _manageSnapshotTable.getSnapshotTableName)(sessionId);
    const records = await sequelize.query(`
      SELECT * FROM ${tableName}
      WHERE id > :fromId
      AND direction = :direction
      ${recordType ? 'AND record_type = :recordType' : ''}
      ${additionalWhere ? `AND ${additionalWhere}` : ''}
      ORDER BY id ASC
      LIMIT :limit;
    `, {
        replacements: {
            fromId,
            recordType,
            direction,
            limit
        },
        type: _sequelize.QueryTypes.SELECT,
        raw: true
    });
    return records.map((r)=>Object.fromEntries(Object.entries(r).map(([key, value])=>[
                (0, _case.camel)(key),
                value
            ])));
};

//# sourceMappingURL=findSyncSnapshotRecords.js.map