"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "incomingSyncHook", {
    enumerable: true,
    get: function() {
        return incomingSyncHook;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _tinyasyncpool = /*#__PURE__*/ _interop_require_default(require("tiny-async-pool"));
const _countSyncSnapshotRecords = require("./countSyncSnapshotRecords");
const _findSyncSnapshotRecords = require("./findSyncSnapshotRecords");
const _constants = require("./constants");
const _manageSnapshotTable = require("./manageSnapshotTable");
const _transactions = require("./transactions");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const persistUpdateWorkerPoolSize = _config.default.sync.persistUpdateWorkerPoolSize;
const incomingSyncHook = async (sequelize, persistedModels, sessionId)=>{
    for (const model of Object.values(persistedModels)){
        if (!model.incomingSyncHook) {
            continue;
        }
        const modelPersistedRecordsCount = await (0, _countSyncSnapshotRecords.countSyncSnapshotRecords)(sequelize, sessionId, _constants.SYNC_SESSION_DIRECTION.INCOMING, model.tableName);
        // Load the persisted record ids in batches to avoid memory issue
        const batchSize = _config.default.sync.incomingSyncHookBatchSize;
        const batchCount = Math.ceil(modelPersistedRecordsCount / batchSize);
        let fromId;
        for(let batchIndex = 0; batchIndex < batchCount; batchIndex++){
            const batchRecords = await (0, _findSyncSnapshotRecords.findSyncSnapshotRecords)(sequelize, sessionId, _constants.SYNC_SESSION_DIRECTION.INCOMING, fromId, batchSize, model.tableName);
            fromId = batchRecords[batchRecords.length - 1]?.id;
            const incomingSnapshotChanges = await (0, _transactions.readOnlyTransaction)(sequelize, async ()=>{
                if (model.incomingSyncHook) {
                    return model.incomingSyncHook(batchRecords);
                }
            });
            if (incomingSnapshotChanges) {
                const { inserts = [], updates = [] } = incomingSnapshotChanges;
                if (inserts.length > 0) {
                    // Mark new changes as requiring repull
                    const newChangesToInsert = inserts.map((change)=>({
                            ...change,
                            requiresRepull: true
                        }));
                    // Insert new changes into sync_snapshot table
                    await (0, _manageSnapshotTable.insertSnapshotRecords)(sequelize, sessionId, newChangesToInsert);
                }
                if (updates.length > 0) {
                    // Mark new changes as requiring repull
                    const newChangesToUpdate = updates.map((change)=>({
                            ...change,
                            requiresRepull: true
                        }));
                    // Update existing changes in sync_snapshot table
                    await (0, _tinyasyncpool.default)(persistUpdateWorkerPoolSize, newChangesToUpdate, async (change)=>(0, _manageSnapshotTable.updateSnapshotRecords)(sequelize, sessionId, change, {
                            id: change.id
                        }));
                }
            }
        }
    }
};

//# sourceMappingURL=incomingSyncHook.js.map