"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    genericBeforeBulkDestroy: function() {
        return genericBeforeBulkDestroy;
    },
    genericBeforeDestroy: function() {
        return genericBeforeDestroy;
    }
});
const _sequelize = require("sequelize");
const _getDependentAssociations = require("./getDependentAssociations");
async function getIds(options) {
    const ids = options.where?.id?.[_sequelize.Op.in];
    if (ids) {
        return ids;
    }
    const instances = await options.model?.findAll(options);
    return instances?.map((x)=>'id' in x ? x.id : undefined);
}
async function executeInsideTransaction(sequelize, arg, fn) {
    if (sequelize.isInsideTransaction()) {
        await fn(arg);
        return;
    }
    await sequelize.transaction(async ()=>{
        await fn(arg);
    });
}
async function beforeDestroy(instance) {
    const dependantAssociations = (0, _getDependentAssociations.getDependentAssociations)(instance.constructor);
    for (const association of dependantAssociations){
        const { target, foreignKey } = association;
        await target.destroy({
            where: {
                [foreignKey]: instance.id
            }
        });
    }
}
async function beforeBulkDestroy(options) {
    const ids = await getIds(options);
    if (ids?.length === 0) {
        return;
    }
    const dependantAssociations = (0, _getDependentAssociations.getDependentAssociations)(options.model);
    for (const association of dependantAssociations){
        const { target, foreignKey } = association;
        await target.destroy({
            where: {
                [foreignKey]: {
                    [_sequelize.Op.in]: ids
                }
            }
        });
    }
}
async function genericBeforeDestroy(instance) {
    const { sequelize } = instance;
    await executeInsideTransaction(sequelize, instance, beforeDestroy);
}
async function genericBeforeBulkDestroy(options) {
    const { sequelize } = options.model;
    await executeInsideTransaction(sequelize, options, beforeBulkDestroy);
}

//# sourceMappingURL=beforeDestroyHooks.js.map