"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getQueryOptions", {
    enumerable: true,
    get: function() {
        return getQueryOptions;
    }
});
function getQueryOptions(models) {
    const { Encounter, Discharge, Patient, Facility, Location, LocationGroup } = models;
    return {
        [Encounter.tableName]: {
            include: [
                {
                    model: Discharge,
                    as: 'discharge',
                    required: false
                },
                {
                    model: Patient,
                    as: 'patient'
                },
                {
                    model: Location,
                    as: 'location',
                    include: [
                        {
                            model: LocationGroup,
                            as: 'locationGroup'
                        }
                    ]
                },
                {
                    model: Location,
                    as: 'location',
                    include: [
                        {
                            model: Facility,
                            as: 'facility'
                        }
                    ]
                }
            ]
        }
    };
}

//# sourceMappingURL=getQueryOptions.js.map