"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "searchParameters", {
    enumerable: true,
    get: function() {
        return searchParameters;
    }
});
const _constants = require("@tamanu/constants");
const searchParameters = {
    class: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'class',
                '[]',
                'coding',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.CODING
    },
    'date-start': {
        type: _constants.FHIR_SEARCH_PARAMETERS.DATE,
        path: [
            [
                'actualPeriod',
                'start'
            ]
        ],
        datePrecision: _constants.FHIR_DATETIME_PRECISION.DAYS
    },
    'end-date': {
        type: _constants.FHIR_SEARCH_PARAMETERS.DATE,
        path: [
            [
                'actualPeriod',
                'end'
            ]
        ],
        datePrecision: _constants.FHIR_DATETIME_PRECISION.DAYS
    },
    status: {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'status'
            ]
        ]
    },
    subject: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'subject'
            ]
        ],
        referenceTypes: [
            'Patient'
        ]
    },
    serviceProvider: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'serviceProvider'
            ]
        ],
        referenceTypes: [
            'Organization'
        ]
    }
};

//# sourceMappingURL=searchParameters.js.map