"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    BadAuthenticationError: function() {
        return BadAuthenticationError;
    },
    BaseAuthenticationError: function() {
        return BaseAuthenticationError;
    }
});
const _BaseError = require("../BaseError");
const _constants = require("../constants");
let BaseAuthenticationError = class BaseAuthenticationError extends _BaseError.BaseError {
    constructor(type, title, detail){
        super(type, title, 401, detail);
    }
};
let BadAuthenticationError = class BadAuthenticationError extends BaseAuthenticationError {
    constructor(detail){
        super(_constants.ERROR_TYPE.AUTH, 'Bad Authentication', detail);
    }
};

//# sourceMappingURL=AuthenticationError.js.map