"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    medicationFrequencyDefault: function() {
        return medicationFrequencyDefault;
    },
    medicationFrequencySchema: function() {
        return medicationFrequencySchema;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _constants = require("@tamanu/constants");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
// Function to check if the time format is valid
const isValidTimeFormat = (time)=>{
    const timeRegex = /^([0-9]{2}):([0-9]{2})$/;
    const match = time.match(timeRegex);
    if (!match) return false;
    const hour = parseInt(match[1], 10);
    const minute = parseInt(match[2], 10);
    return hour >= 0 && hour <= 23 && minute >= 0 && minute <= 59;
};
// Function to check if all times are unique 2-hour blocks
const hasUniqueTimeWindows = (times)=>{
    const seenWindows = new Set();
    for (const time of times){
        const windowBlock = Math.floor(parseInt(time.split(':')[0], 10) / 2); // Unique key for 2-hour blocks
        if (seenWindows.has(windowBlock)) {
            return false;
        }
        seenWindows.add(windowBlock);
    }
    return true;
};
const validateAdministrationIdealTimes = (value, ctx, frequencyKey)=>{
    // Check if array length equals the expected number of doses per day
    const expectedDosesPerDay = Math.ceil(_constants.ADMINISTRATION_FREQUENCY_DETAILS[frequencyKey].dosesPerDay);
    if (value.length !== expectedDosesPerDay) {
        return ctx.createError({
            message: `You must specify a number of ${expectedDosesPerDay} administration windows.`
        });
    }
    // Ensure there are no duplicate 2-hour windows
    if (!hasUniqueTimeWindows(value)) {
        return ctx.createError({
            message: 'Duplicate 2-hour time blocks are not allowed. Ensure all times represent unique 2-hour windows.'
        });
    }
    // Validate each time format
    for (const time of value){
        if (!isValidTimeFormat(time)) {
            return ctx.createError({
                message: `Invalid time format: ${time}. Times must be in HH:mm format.`
            });
        }
    }
    return true;
};
const medicationFrequencySchema = (frequencyKey)=>_yup.array(_yup.string()).nullable().test({
        name: 'validate-administration-ideal-times',
        test (value, ctx) {
            if (!value) return true;
            return validateAdministrationIdealTimes(value, ctx, frequencyKey);
        }
    });
const medicationFrequencyDefault = Object.entries(_constants.ADMINISTRATION_FREQUENCY_DETAILS).reduce((acc, [key, value])=>{
    acc[key] = value.startTimes;
    return acc;
}, {});

//# sourceMappingURL=medicationFrequencySchema.js.map