import { isObject, isUndefined, mapValues, omitBy } from 'lodash';
export const isSetting = (value)=>{
    return value && isObject(value) && 'type' in value && 'defaultValue' in value;
};
export const isSettingsSchema = (value)=>{
    return value && isObject(value) && 'properties' in value;
};
export const extractDefaults = (settings)=>{
    const result = mapValues(settings.properties, (value)=>isSetting(value) ? value.defaultValue : extractDefaults(value));
    return omitBy(result, isUndefined);
};

//# sourceMappingURL=utils.js.map