"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    GENERIC_SURVEY_EXPORT_REPORT_ID: function() {
        return _reportDefinitions.GENERIC_SURVEY_EXPORT_REPORT_ID;
    },
    REPORT_DEFINITIONS: function() {
        return _reportDefinitions.REPORT_DEFINITIONS;
    },
    REPORT_OBJECTS: function() {
        return _reportObjects.REPORT_OBJECTS;
    },
    getReportModule: function() {
        return getReportModule;
    }
});
const _admissions = /*#__PURE__*/ _interop_require_wildcard(require("./admissions"));
const _incompletereferrals = /*#__PURE__*/ _interop_require_wildcard(require("./incomplete-referrals"));
const _recentdiagnoses = /*#__PURE__*/ _interop_require_wildcard(require("./recent-diagnoses"));
const _vaccinelist = /*#__PURE__*/ _interop_require_wildcard(require("./vaccine-list"));
const _tuvaluvaccinelist = /*#__PURE__*/ _interop_require_wildcard(require("./tuvalu-vaccine-list"));
const _covidvaccinelist = /*#__PURE__*/ _interop_require_wildcard(require("./covid-module/covid-vaccine-list"));
const _covidvaccinesummary = require("./covid-module/covid-vaccine-summary");
const _aefi = /*#__PURE__*/ _interop_require_wildcard(require("./aefi"));
const _samoaaefi = /*#__PURE__*/ _interop_require_wildcard(require("./samoa-aefi"));
const _numberpatientsregisteredbydate = /*#__PURE__*/ _interop_require_wildcard(require("./number-patients-registered-by-date"));
const _registeredpatients = /*#__PURE__*/ _interop_require_wildcard(require("./registered-patients"));
const _fijicovidswablabtestlist = /*#__PURE__*/ _interop_require_wildcard(require("./covid-module/fiji/fiji-covid-swab-lab-test-list"));
const _fijitravellercovidlabtestlist = /*#__PURE__*/ _interop_require_wildcard(require("./covid-module/fiji/fiji-traveller-covid-lab-test-list"));
const _palaucovidswablabtestlist = /*#__PURE__*/ _interop_require_wildcard(require("./covid-module/palau/palau-covid-swab-lab-test-list"));
const _naurucovidswablabtestlist = /*#__PURE__*/ _interop_require_wildcard(require("./covid-module/nauru/nauru-covid-swab-lab-test-list"));
const _kiribaticovidswablabtestlist = /*#__PURE__*/ _interop_require_wildcard(require("./covid-module/kiribati/kiribati-covid-swab-lab-test-list"));
const _samoacovidswablabtestlist = /*#__PURE__*/ _interop_require_wildcard(require("./covid-module/samoa/samoa-covid-swab-lab-test-list"));
const _covidswablabtestssummary = /*#__PURE__*/ _interop_require_wildcard(require("./covid-module/covid-swab-lab-tests-summary"));
const _indiaassistivetechnologydevicelinelist = /*#__PURE__*/ _interop_require_wildcard(require("./india-assistive-technology-device-line-list"));
const _iraqassistivetechnologydevicelinelist = /*#__PURE__*/ _interop_require_wildcard(require("./iraq-assistive-technology-device-line-list"));
const _pngassistivetechnologydevicelinelist = /*#__PURE__*/ _interop_require_wildcard(require("./png-assistive-technology-device-line-list"));
const _encountersummarylinelist = /*#__PURE__*/ _interop_require_wildcard(require("./encounter-summary-line-list"));
const _fijirecentattendancelist = /*#__PURE__*/ _interop_require_wildcard(require("./fiji-recent-attendance-list"));
const _fijincdprimaryscreeninglinelist = /*#__PURE__*/ _interop_require_wildcard(require("./fiji-ncd-primary-screening/fiji-ncd-primary-screening-line-list"));
const _fijincdprimaryscreeningpendingreferralslinelist = /*#__PURE__*/ _interop_require_wildcard(require("./fiji-ncd-primary-screening/fiji-ncd-primary-screening-pending-referrals-line-list"));
const _fijincdprimaryscreeningsummary = /*#__PURE__*/ _interop_require_wildcard(require("./fiji-ncd-primary-screening/fiji-ncd-primary-screening-summary"));
const _fijistatisticalreportforphissummary = /*#__PURE__*/ _interop_require_wildcard(require("./fiji-statistical-report-for-phis-summary"));
const _palaucovidcasereportlinelist = /*#__PURE__*/ _interop_require_wildcard(require("./covid-module/palau/palau-covid-case-report-line-list"));
const _genericsurveyexportlinelist = /*#__PURE__*/ _interop_require_wildcard(require("./generic-survey-export-line-list"));
const _appointmentslinelist = /*#__PURE__*/ _interop_require_wildcard(require("./appointments-line-list"));
const _imagingrequestslinelist = /*#__PURE__*/ _interop_require_wildcard(require("./imaging-requests-line-list"));
const _deceasedpatientslinelist = /*#__PURE__*/ _interop_require_wildcard(require("./deceased-patients-line-list"));
const _labrequestslinelist = /*#__PURE__*/ _interop_require_wildcard(require("./lab-requests-line-list"));
const _fijiaspenhospitaladmissionssummary = /*#__PURE__*/ _interop_require_wildcard(require("./fiji-aspen-hospital-admissions-summary"));
const _registeredbirthslinelist = /*#__PURE__*/ _interop_require_wildcard(require("./registered-births-line-list"));
const _reportDefinitions = require("./reportDefinitions");
const _reportObjects = require("./reportObjects");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function getReportModule(reportId, models) {
    const dbDefinedReportModule = await models.ReportDefinitionVersion.findByPk(reportId);
    if (dbDefinedReportModule) {
        return dbDefinedReportModule;
    }
    switch(reportId){
        default:
            return null;
        case 'admissions':
            return _admissions;
        case 'incomplete-referrals':
            return _incompletereferrals;
        case 'recent-diagnoses':
            return _recentdiagnoses;
        case 'vaccine-list':
            return _vaccinelist;
        case 'tuvalu-vaccine-list':
            return _tuvaluvaccinelist;
        case 'covid-vaccine-list':
            return _covidvaccinelist;
        case 'covid-vaccine-summary-dose1':
            return {
                dataGenerator: _covidvaccinesummary.generateCovidVaccineSummaryDose1Report
            };
        case 'covid-vaccine-summary-dose2':
            return {
                dataGenerator: _covidvaccinesummary.generateCovidVaccineSummaryDose2Report
            };
        case 'aefi':
            return _aefi;
        case 'samoa-aefi':
            return _samoaaefi;
        case 'number-patients-registered-by-date':
            return _numberpatientsregisteredbydate;
        case 'registered-patients':
            return _registeredpatients;
        case 'fiji-covid-swab-lab-test-list':
            return _fijicovidswablabtestlist;
        case 'fiji-traveller-covid-lab-test-list':
            return _fijitravellercovidlabtestlist;
        case 'palau-covid-swab-lab-test-list':
            return _palaucovidswablabtestlist;
        case 'nauru-covid-swab-lab-test-list':
            return _naurucovidswablabtestlist;
        case 'kiribati-covid-swab-lab-test-list':
            return _kiribaticovidswablabtestlist;
        case 'samoa-covid-swab-lab-test-list':
            return _samoacovidswablabtestlist;
        case 'covid-swab-lab-tests-summary':
            return _covidswablabtestssummary;
        case 'india-assistive-technology-device-line-list':
            return _indiaassistivetechnologydevicelinelist;
        case 'iraq-assistive-technology-device-line-list':
            return _iraqassistivetechnologydevicelinelist;
        case 'png-assistive-technology-device-line-list':
            return _pngassistivetechnologydevicelinelist;
        case 'encounter-summary-line-list':
            return _encountersummarylinelist;
        case 'fiji-recent-attendance-list':
            return _fijirecentattendancelist;
        case 'fiji-ncd-primary-screening-line-list':
            return _fijincdprimaryscreeninglinelist;
        case 'fiji-ncd-primary-screening-pending-referrals-line-list':
            return _fijincdprimaryscreeningpendingreferralslinelist;
        case 'fiji-ncd-primary-screening-summary':
            return _fijincdprimaryscreeningsummary;
        case 'fiji-statistical-report-for-phis-summary':
            return _fijistatisticalreportforphissummary;
        case 'palau-covid-case-report-line-list':
            return _palaucovidcasereportlinelist;
        case 'generic-survey-export-line-list':
            return _genericsurveyexportlinelist;
        case 'appointments-line-list':
            return _appointmentslinelist;
        case 'imaging-requests-line-list':
            return _imagingrequestslinelist;
        case 'deceased-patients-line-list':
            return _deceasedpatientslinelist;
        case 'lab-requests-line-list':
            return _labrequestslinelist;
        case 'fiji-aspen-hospital-admissions-summary':
            return _fijiaspenhospitaladmissionssummary;
        case 'registered-births-line-list':
            return _registeredbirthslinelist;
    }
}

//# sourceMappingURL=index.js.map