// @ts-check
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "defineHook", {
    enumerable: true,
    get: function() {
        return defineHook;
    }
});
const _hookable = require("hookable");
const hooks = (0, _hookable.createHooks)();
const defineHook = (hookName)=>{
    const on = (func)=>hooks.hook(hookName, func);
    const trigger = (payload)=>hooks.callHook(hookName, payload);
    return {
        on,
        trigger
    };
};

//# sourceMappingURL=hook.js.map