"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    REPORT_DATA_SOURCES: function() {
        return REPORT_DATA_SOURCES;
    },
    REPORT_DATA_SOURCE_LABELS: function() {
        return REPORT_DATA_SOURCE_LABELS;
    },
    REPORT_DATA_SOURCE_VALUES: function() {
        return REPORT_DATA_SOURCE_VALUES;
    },
    REPORT_DATE_RANGE_LABELS: function() {
        return REPORT_DATE_RANGE_LABELS;
    },
    REPORT_DB_SCHEMAS: function() {
        return REPORT_DB_SCHEMAS;
    },
    REPORT_DB_SCHEMA_LABELS: function() {
        return REPORT_DB_SCHEMA_LABELS;
    },
    REPORT_DB_SCHEMA_VALUES: function() {
        return REPORT_DB_SCHEMA_VALUES;
    },
    REPORT_DEFAULT_DATE_RANGES: function() {
        return REPORT_DEFAULT_DATE_RANGES;
    },
    REPORT_DEFAULT_DATE_RANGES_LABELS: function() {
        return REPORT_DEFAULT_DATE_RANGES_LABELS;
    },
    REPORT_DEFAULT_DATE_RANGES_VALUES: function() {
        return REPORT_DEFAULT_DATE_RANGES_VALUES;
    },
    REPORT_EXPORT_FORMATS: function() {
        return REPORT_EXPORT_FORMATS;
    },
    REPORT_REQUEST_STATUSES: function() {
        return REPORT_REQUEST_STATUSES;
    },
    REPORT_REQUEST_STATUS_VALUES: function() {
        return REPORT_REQUEST_STATUS_VALUES;
    },
    REPORT_STATUSES: function() {
        return REPORT_STATUSES;
    },
    REPORT_STATUSES_VALUES: function() {
        return REPORT_STATUSES_VALUES;
    },
    REPORT_STATUS_LABELS: function() {
        return REPORT_STATUS_LABELS;
    },
    REPORT_VERSION_EXPORT_FORMATS: function() {
        return REPORT_VERSION_EXPORT_FORMATS;
    }
});
const REPORT_REQUEST_STATUSES = {
    RECEIVED: 'Received',
    PROCESSING: 'Processing',
    PROCESSED: 'Processed',
    ERROR: 'Error'
};
const REPORT_REQUEST_STATUS_VALUES = Object.values(REPORT_REQUEST_STATUSES);
const REPORT_DATA_SOURCES = {
    THIS_FACILITY: 'thisFacility',
    ALL_FACILITIES: 'allFacilities'
};
const REPORT_DATA_SOURCE_LABELS = {
    [REPORT_DATA_SOURCES.THIS_FACILITY]: 'This facility',
    [REPORT_DATA_SOURCES.ALL_FACILITIES]: 'All facilities'
};
const REPORT_DATA_SOURCE_VALUES = Object.values(REPORT_DATA_SOURCES);
const REPORT_EXPORT_FORMATS = {
    XLSX: 'xlsx',
    CSV: 'csv'
};
const REPORT_VERSION_EXPORT_FORMATS = {
    SQL: 'sql',
    JSON: 'json'
};
const REPORT_STATUSES = {
    DRAFT: 'draft',
    PUBLISHED: 'published'
};
const REPORT_STATUS_LABELS = {
    [REPORT_STATUSES.DRAFT]: 'Draft',
    [REPORT_STATUSES.PUBLISHED]: 'Published'
};
const REPORT_STATUSES_VALUES = Object.values(REPORT_STATUSES);
const REPORT_DEFAULT_DATE_RANGES = {
    ALL_TIME: 'allTime',
    EIGHTEEN_YEARS: '18years',
    THIRTY_DAYS: '30days',
    SEVEN_DAYS: '7days',
    TWENTY_FOUR_HOURS: '24hours',
    NEXT_THIRTY_DAYS: 'next30days'
};
const REPORT_DEFAULT_DATE_RANGES_LABELS = {
    [REPORT_DEFAULT_DATE_RANGES.ALL_TIME]: 'All time',
    [REPORT_DEFAULT_DATE_RANGES.EIGHTEEN_YEARS]: 'Past 18 years',
    [REPORT_DEFAULT_DATE_RANGES.THIRTY_DAYS]: 'Past 30 days',
    [REPORT_DEFAULT_DATE_RANGES.SEVEN_DAYS]: 'Past 7 days',
    [REPORT_DEFAULT_DATE_RANGES.TWENTY_FOUR_HOURS]: 'Past 24 hours',
    [REPORT_DEFAULT_DATE_RANGES.NEXT_THIRTY_DAYS]: 'Next 30 days'
};
const REPORT_DATE_RANGE_LABELS = {
    [REPORT_DEFAULT_DATE_RANGES.ALL_TIME]: 'Date range (or leave blank for all data)',
    [REPORT_DEFAULT_DATE_RANGES.EIGHTEEN_YEARS]: 'Date range (or leave blank for the past 18 years of data)',
    [REPORT_DEFAULT_DATE_RANGES.THIRTY_DAYS]: 'Date range (or leave blank for the past 30 days of data)',
    [REPORT_DEFAULT_DATE_RANGES.SEVEN_DAYS]: 'Date range (or leave blank for the past 7 days of data)',
    [REPORT_DEFAULT_DATE_RANGES.TWENTY_FOUR_HOURS]: 'Date range (or leave blank for the past 24 hours of data)',
    [REPORT_DEFAULT_DATE_RANGES.NEXT_THIRTY_DAYS]: 'Date range (or leave blank for the next 30 days of data)'
};
const REPORT_DEFAULT_DATE_RANGES_VALUES = Object.values(REPORT_DEFAULT_DATE_RANGES);
const REPORT_DB_SCHEMAS = {
    REPORTING: 'reporting',
    RAW: 'raw'
};
const REPORT_DB_SCHEMA_VALUES = Object.values(REPORT_DB_SCHEMAS);
const REPORT_DB_SCHEMA_LABELS = {
    [REPORT_DB_SCHEMAS.REPORTING]: 'Reporting',
    [REPORT_DB_SCHEMAS.RAW]: 'Raw'
};

//# sourceMappingURL=reports.js.map