"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    TEMPLATE_TYPES: function() {
        return TEMPLATE_TYPES;
    },
    TEMPLATE_TYPE_LABELS: function() {
        return TEMPLATE_TYPE_LABELS;
    }
});
const _notes = require("./notes.js");
const TEMPLATE_TYPES = {
    PATIENT_LETTER: 'patientLetter',
    TREATMENT_PLAN: _notes.NOTE_TYPES.TREATMENT_PLAN,
    ADMISSION: _notes.NOTE_TYPES.ADMISSION,
    DIETARY: _notes.NOTE_TYPES.DIETARY,
    DISCHARGE: _notes.NOTE_TYPES.DISCHARGE,
    HANDOVER: _notes.NOTE_TYPES.HANDOVER,
    MEDICAL: _notes.NOTE_TYPES.MEDICAL,
    NURSING: _notes.NOTE_TYPES.NURSING,
    OTHER: _notes.NOTE_TYPES.OTHER,
    PHARMACY: _notes.NOTE_TYPES.PHARMACY,
    PHYSIOTHERAPY: _notes.NOTE_TYPES.PHYSIOTHERAPY,
    SOCIAL: _notes.NOTE_TYPES.SOCIAL,
    SURGICAL: _notes.NOTE_TYPES.SURGICAL
};
const TEMPLATE_TYPE_LABELS = {
    [TEMPLATE_TYPES.PATIENT_LETTER]: 'Patient letter',
    [TEMPLATE_TYPES.TREATMENT_PLAN]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.TREATMENT_PLAN],
    [TEMPLATE_TYPES.ADMISSION]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.ADMISSION],
    [TEMPLATE_TYPES.MEDICAL]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.MEDICAL],
    [TEMPLATE_TYPES.SURGICAL]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.SURGICAL],
    [TEMPLATE_TYPES.NURSING]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.NURSING],
    [TEMPLATE_TYPES.DIETARY]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.DIETARY],
    [TEMPLATE_TYPES.PHARMACY]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.PHARMACY],
    [TEMPLATE_TYPES.PHYSIOTHERAPY]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.PHYSIOTHERAPY],
    [TEMPLATE_TYPES.SOCIAL]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.SOCIAL],
    [TEMPLATE_TYPES.DISCHARGE]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.DISCHARGE],
    [TEMPLATE_TYPES.OTHER]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.OTHER],
    [TEMPLATE_TYPES.HANDOVER]: _notes.NOTE_TYPE_LABELS[_notes.NOTE_TYPES.HANDOVER]
};

//# sourceMappingURL=templates.js.map