"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const REPORT_STATUSES = {
    DRAFT: 'draft',
    PUBLISHED: 'published'
};
const basics = {
    id: {
        type: _sequelize.STRING,
        defaultValue: _sequelize.UUIDV4,
        allowNull: false,
        primaryKey: true
    },
    created_at: {
        type: _sequelize.DATE,
        defaultValue: _sequelize.NOW
    },
    updated_at: {
        type: _sequelize.DATE,
        defaultValue: _sequelize.NOW
    },
    deleted_at: {
        type: _sequelize.DATE,
        defaultValue: _sequelize.NOW
    }
};
const syncColumns = {
    marked_for_push: {
        type: _sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: true
    },
    is_pushing: {
        type: _sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: false
    },
    pushed_at: {
        type: _sequelize.DATE,
        allowNull: true
    },
    pulled_at: {
        type: _sequelize.DATE,
        allowNull: true
    }
};
async function up(query) {
    // Add Report Definition Table
    await query.createTable('report_definitions', {
        ...basics,
        ...syncColumns,
        name: {
            type: _sequelize.STRING,
            allowNull: false
        }
    });
    // Add Report Definition Version Table
    await query.createTable('report_definition_versions', {
        ...basics,
        ...syncColumns,
        version_number: {
            type: _sequelize.INTEGER,
            allowNull: false
        },
        notes: {
            type: _sequelize.STRING,
            allowNull: true
        },
        status: {
            type: _sequelize.STRING,
            allowNull: false,
            defaultValue: REPORT_STATUSES.DRAFT
        },
        query: {
            type: _sequelize.TEXT,
            allowNull: true
        },
        query_options: {
            type: _sequelize.JSON,
            allowNull: true
        },
        report_definition_id: {
            type: _sequelize.STRING,
            allowNull: true,
            references: {
                model: 'report_definitions',
                key: 'id'
            }
        },
        user_id: {
            type: _sequelize.STRING,
            references: {
                model: 'users',
                key: 'id'
            },
            allowNull: false
        }
    });
    // Update Existing Report Request Table
    await query.addColumn('report_requests', 'facility_id', {
        type: _sequelize.STRING,
        allowNull: true,
        references: {
            model: 'facilities',
            key: 'id'
        }
    });
    await query.addColumn('report_requests', 'export_format', {
        type: _sequelize.STRING,
        allowNull: false,
        defaultValue: 'xlsx'
    });
    await query.addColumn('report_requests', 'report_definition_version_id', {
        type: _sequelize.STRING,
        allowNull: true,
        references: {
            model: 'report_definition_versions',
            key: 'id'
        }
    });
    await query.changeColumn('report_requests', 'report_type', {
        type: _sequelize.STRING,
        allowNull: true
    });
}
async function down(query) {
    // Undo Updates to Report Requests Table
    await query.removeColumn('report_requests', 'facility_id');
    await query.removeColumn('report_requests', 'report_definition_version_id');
    // Remove Report Definition Table
    await query.dropTable('report_definition_versions');
    // Remove Report Definition Version Table
    await query.dropTable('report_definitions');
}

//# sourceMappingURL=087_addDatabaseReportsModels.js.map