"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const TABLES = {
    patients: {
        birth_date: _sequelize.DataTypes.DATESTRING,
        deceased_date_time: _sequelize.DataTypes.DATESTRING
    },
    service_requests: {
        occurrence_date_time: _sequelize.DataTypes.DATE
    },
    diagnostic_reports: {
        effective_date_time: _sequelize.DataTypes.DATE,
        issued: _sequelize.DataTypes.DATE
    },
    immunizations: {
        occurrence_date_time: _sequelize.DataTypes.DATETIMESTRING
    }
};
async function up(query) {
    const COUNTRY_TIMEZONE = _config.default?.countryTimeZone;
    if (!COUNTRY_TIMEZONE) {
        throw Error('A countryTimeZone must be configured in local.json5 for this migration to run.');
    }
    // Save previously set time zone
    const previousTimeZoneQuery = await query.sequelize.query('show timezone');
    const previousTimeZone = previousTimeZoneQuery[0].TimeZone;
    // Set time zone defined in config
    await query.sequelize.query(`SET timezone to '${COUNTRY_TIMEZONE}'`);
    for (const [tableName, columns] of Object.entries(TABLES)){
        for (const [columnName, columnType] of Object.entries(columns)){
            if (columnType === _sequelize.DataTypes.DATE) {
                await query.sequelize.query(`
          ALTER TABLE fhir.${tableName}
            ALTER COLUMN ${columnName}
              TYPE TEXT
                USING to_json(${columnName})#>>'{}'
        `);
            } else if (columnType === _sequelize.DataTypes.DATETIMESTRING) {
                await query.sequelize.query(`
          ALTER TABLE fhir.${tableName}
            ALTER COLUMN ${columnName}
              TYPE TEXT
                USING to_json(to_timestamp(${columnName}, 'YYYY-MM-DD hh24:mi:ss'))#>>'{}'
        `);
            } else {
                await query.sequelize.query(`
          ALTER TABLE fhir.${tableName}
            ALTER COLUMN ${columnName}
              TYPE TEXT
        `);
            }
        }
    }
    // Reset time zone for containment
    await query.sequelize.query(`SET timezone to '${previousTimeZone}'`);
}
async function down(query) {
    for (const [tableName, columns] of Object.entries(TABLES)){
        await query.sequelize.query(`TRUNCATE TABLE fhir.${tableName}`);
        const table = {
            schema: 'fhir',
            tableName
        };
        for (const [columnName, columnType] of Object.entries(columns)){
            await query.removeColumn(table, columnName);
            await query.addColumn(table, columnName, {
                type: columnType
            });
        }
    }
}

//# sourceMappingURL=1677797056646-changeFhirTableDatesToStrings.js.map