"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    // Create encounter_pause_prescriptions table
    await query.createTable('encounter_pause_prescriptions', {
        id: {
            type: _sequelize.DataTypes.STRING,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid'),
            allowNull: false,
            primaryKey: true
        },
        encounter_prescription_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'encounter_prescriptions',
                key: 'id'
            },
            onUpdate: 'CASCADE',
            onDelete: 'CASCADE'
        },
        pause_duration: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        pause_time_unit: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        pause_start_date: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        pause_end_date: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        notes: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        pausing_clinician_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            },
            onUpdate: 'CASCADE',
            onDelete: 'SET NULL'
        },
        created_by: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            },
            onUpdate: 'CASCADE',
            onDelete: 'SET NULL'
        },
        updated_by: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            },
            onUpdate: 'CASCADE',
            onDelete: 'SET NULL'
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    // Create encounter_pause_prescription_histories table
    await query.createTable('encounter_pause_prescription_histories', {
        id: {
            type: _sequelize.DataTypes.STRING,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid'),
            allowNull: false,
            primaryKey: true
        },
        encounter_prescription_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'encounter_prescriptions',
                key: 'id'
            },
            onUpdate: 'CASCADE',
            onDelete: 'CASCADE'
        },
        action: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        action_date: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        action_user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            },
            onUpdate: 'CASCADE',
            onDelete: 'SET NULL'
        },
        notes: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        },
        pause_duration: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: true
        },
        pause_time_unit: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    // Create indexes for better query performance
    await query.addIndex('encounter_pause_prescriptions', [
        'encounter_prescription_id'
    ]);
    await query.addIndex('encounter_pause_prescriptions', [
        'pause_end_date'
    ]);
    await query.addIndex('encounter_pause_prescription_histories', [
        'encounter_prescription_id'
    ]);
    await query.addIndex('encounter_pause_prescription_histories', [
        'action_date'
    ]);
}
async function down(query) {
    // Drop indexes
    await query.removeIndex('encounter_pause_prescription_histories', [
        'action_date'
    ]);
    await query.removeIndex('encounter_pause_prescription_histories', [
        'encounter_prescription_id'
    ]);
    await query.removeIndex('encounter_pause_prescriptions', [
        'pause_end_date'
    ]);
    await query.removeIndex('encounter_pause_prescriptions', [
        'encounter_prescription_id'
    ]);
    // Drop tables
    await query.dropTable('encounter_pause_prescription_histories');
    await query.dropTable('encounter_pause_prescriptions');
}

//# sourceMappingURL=1741597792321-addPrescriptionPauseTables.js.map