"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "AccessLog", {
    enumerable: true,
    get: function() {
        return AccessLog;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let AccessLog = class AccessLog extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            loggedAt: {
                type: _sequelize.DataTypes.DATE,
                allowNull: false
            },
            frontEndContext: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            },
            backEndContext: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            },
            recordId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            recordType: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            sessionId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            deviceId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            isMobile: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false
            },
            version: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            }
        }, {
            ...options,
            tableName: 'accesses',
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            schema: 'logs'
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId',
            as: 'facility'
        });
    }
};

//# sourceMappingURL=AccessLog.js.map