"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoicePayment", {
    enumerable: true,
    get: function() {
        return InvoicePayment;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _model = require("../types/model");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
let InvoicePayment = class InvoicePayment extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: (0, _model.dateType)('date', {
                allowNull: false
            }),
            receiptNumber: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            amount: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Invoice, {
            foreignKey: 'invoiceId',
            as: 'invoice'
        });
        this.hasOne(models.InvoicePatientPayment, {
            foreignKey: 'invoicePaymentId',
            as: 'patientPayment'
        });
        this.hasOne(models.InvoiceInsurerPayment, {
            foreignKey: 'invoicePaymentId',
            as: 'insurerPayment'
        });
        this.belongsTo(models.User, {
            foreignKey: 'updatedByUserId',
            as: 'updatedByUser'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupSelect)(this),
            joins: (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupJoins)(this, [
                'invoices',
                'encounters'
            ])
        };
    }
    static getListReferenceAssociations(models) {
        return [
            {
                model: models.User,
                as: 'updatedByUser'
            },
            {
                model: models.InvoicePatientPayment,
                as: 'patientPayment',
                include: models.InvoicePatientPayment.getListReferenceAssociations(models)
            },
            {
                model: models.InvoiceInsurerPayment,
                as: 'insurerPayment',
                include: models.InvoiceInsurerPayment.getListReferenceAssociations(models)
            }
        ];
    }
};

//# sourceMappingURL=InvoicePayment.js.map