"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "UserLocalisationCache", {
    enumerable: true,
    get: function() {
        return UserLocalisationCache;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let UserLocalisationCache = class UserLocalisationCache extends _Model.Model {
    static initModel(options) {
        super.init({
            id: {
                type: _sequelize.DataTypes.UUID,
                allowNull: false,
                primaryKey: true,
                defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
            },
            localisation: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            indexes: [
                {
                    fields: [
                        'user_id'
                    ],
                    unique: true
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
    }
    static async getLocalisation(options) {
        const localisationCache = await this.findOne(options);
        if (!localisationCache) {
            return null;
        }
        return JSON.parse(localisationCache.localisation);
    }
};

//# sourceMappingURL=UserLocalisationCache.js.map