"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "insertChangelogRecords", {
    enumerable: true,
    get: function() {
        return insertChangelogRecords;
    }
});
const insertChangelogRecords = async (models, changelogRecords)=>{
    const { ChangeLog } = models;
    if (!changelogRecords.length) {
        return;
    }
    const existingRecords = await ChangeLog.findAll({
        where: {
            id: changelogRecords.map(({ id })=>id)
        }
    });
    const existingIds = existingRecords.map(({ id })=>id);
    const recordsToInsert = changelogRecords.filter(({ id })=>!existingIds.includes(id)).map((changelogRecord)=>({
            ...changelogRecord
        }));
    await ChangeLog.bulkCreate(recordsToInsert);
};

//# sourceMappingURL=insertChangelogRecords.js.map