"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    activeFromVisibility: function() {
        return activeFromVisibility;
    },
    objectAsFhir: function() {
        return objectAsFhir;
    }
});
const _lodash = require("lodash");
const _constants = require("@tamanu/constants");
function mapAndCompactArray(input) {
    return input.map((v)=>objectAsFhir(v)).filter((v)=>v !== null && v !== undefined);
}
function objectAsFhir(input) {
    if (Array.isArray(input)) {
        return mapAndCompactArray(input);
    }
    if (!(0, _lodash.isPlainObject)(input)) {
        return input;
    }
    const obj = {};
    for (const [name, value] of Object.entries(input)){
        if (value === null || value === undefined) {
            continue;
        } else if (Array.isArray(value)) {
            obj[name] = mapAndCompactArray(value);
        } else if ((0, _lodash.isPlainObject)(value)) {
            obj[name] = objectAsFhir(value);
        } else {
            obj[name] = value;
        }
    }
    return obj;
}
function activeFromVisibility(upstream) {
    switch(upstream.visibilityStatus){
        case _constants.VISIBILITY_STATUSES.CURRENT:
            return !upstream.deletedAt;
        default:
            return false;
    }
}

//# sourceMappingURL=utils.js.map