import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class InvoiceItem extends Model {
    id: string;
    orderDate: string;
    productId?: string;
    quantity: number;
    note?: string;
    sourceId?: string;
    productName: string;
    productPrice: number;
    productCode: string;
    productDiscountable: boolean;
    invoiceId?: string;
    orderedByUserId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static getListReferenceAssociations(models: Models): ({
        model: typeof import("./InvoiceProduct").InvoiceProduct;
        as: string;
        include: ({
            model: typeof import("./ReferenceData").ReferenceData;
            as: string;
            attributes: string[];
        } | {
            model: typeof import("./LabTestType").LabTestType;
            as: string;
            attributes: string[];
        })[];
        attributes?: undefined;
    } | {
        model: typeof import("./User").User;
        as: string;
        attributes: string[];
        include?: undefined;
    } | {
        model: typeof import("./InvoiceItemDiscount").InvoiceItemDiscount;
        as: string;
        include?: undefined;
        attributes?: undefined;
    })[];
}
//# sourceMappingURL=InvoiceItem.d.ts.map